﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.BENS;
using System.Data;
using System.Collections;
using System.IO;
using System.Reflection;
using System.Collections.Specialized;
using System.Web.Script.Serialization;
using System.Web.Configuration;
using System.Text.RegularExpressions;

namespace AHOBPR_WcfService
{
    public class AHOBPR : IAHOBPR
    {
        #region GET Methods for Registrant Portal

        /// <summary>
        /// Parse JSON data and save the data to SQL tables
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool JsonParser(string id)
        {
            bool result = false;

            if (string.IsNullOrEmpty(id))
            {
                result = true;
            }
            else
            {
                try
                {
                    AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
                    result = manager.ParseJsonData(Convert.ToInt32(id));
                }
                catch
                {
                    result = false;
                }
            }

            return result;
        }
        public bool AddEdipiForUpdate(string edipi)
        {
            bool result = false;
            try
            {
                Regex regex = new Regex("^[0-9]{10}$");
                if (regex.IsMatch(edipi))
                {
                    var manager = new DataManager();
                    result = manager.AddEdipiToDatabase(edipi);
                }
            }
            catch
            {
                result = false;
            }
            return result;
        }
        /// <summary>
        /// This pulls unprocessed BENS notifications and compares them against the list of registrants
        /// Any matching registrants update their information with the latest data pulled from EMIS
        /// </summary>
        /// <returns></returns>
        public string ProcessNotifications()
        {
            string result = string.Empty;
            try
            {
                ComprehensiveUpdater updater = new ComprehensiveUpdater();
                result = updater.ReconcileQueue(new List<IRegistrantUpdater>() { new RegistrantRetirementImporter() });
            }
            catch
            {
                result = "error";
            }
            return result;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool JsonParserFollowup(string id)
        {
            bool result = false;

            if (string.IsNullOrEmpty(id))
            {
                result = true;
            }
            else
            {
                try
                {
                    AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
                    result = manager.ParseJsonFollowupData(Convert.ToInt32(id));
                }
                catch
                {
                    result = false;
                }
            }

            return result;
        }

        /// <summary>
        /// Get PDF file
        /// </summary>
        /// <param name="fileType"></param>
        /// /// <param name="fileId"></param>
        /// <returns></returns>
        public byte[] GetFile(string fileType, string fileId)
        {
            AHOBPRFileManager manager = new AHOBPRFileManager();
            return manager.GetFile(fileId, fileType);
        }

        /// <summary>
        /// Get user role by username
        /// </summary>
        /// <param name="username"></param>
        /// <returns></returns>
        public string UserRole(string username)
        {
            string role = string.Empty;
            AHOBPRGenericManager manager = new AHOBPRGenericManager();
            role = manager.GetUserRole(username);
            return role;
        }

        /// <summary>
        /// Get application notification that can be displayed on the banner in the registrant portal
        /// </summary>
        /// <returns></returns>
        public string AppNotification()
        {
            AHOBPRGenericManager manager = new AHOBPRGenericManager();
            return manager.GetApplicationNotification();
        }
        /// <summary>
        /// Reset global variables
        /// </summary>
        /// <returns></returns>
        public bool ResetGlobalVariables()
        {
            bool result = false;
            AHOBPRFormResponseManager manager = new AHOBPRFormResponseManager();
            result = manager.ResetGlobalVariables();
            return result;
        }
        /// <summary>
        /// Get Version #
        /// </summary>
        /// <returns></returns>
        public string Version()
        {
            return BaseCode.WebSiteVersion.BuildVersion.ToString();
            //return WebConfigurationManager.AppSettings["Version"];
        }

        /// <summary>
        /// Get Bpr DoD Import
        /// </summary>
        /// <param name="edipi"></param>
        /// <param name="ssn"></param>
        /// <returns></returns>
        public string BprDoDImport(string edipi, string ssn)
        {
            BprDoDDeploymentImports imports = null;
            try
            {
                IDeploymentImporter manager = CreateDoDImporter();
                imports = manager.GetDoDDeploymentImports(edipi, ssn);
            }
            catch (NullReferenceException ex)
            {
                AHOBPRLogger.LogErrorMessage("Null Reference", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
            }
            catch (Exception ex)
            {
                AHOBPRLogger.LogErrorMessage("Exception", GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.StackTrace);
            }
            return (imports != null) ? new JavaScriptSerializer().Serialize(imports) : "{}";
        }

        /// <summary>
        /// Get Bpr Info
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string BprInfo(string id)
        {
            string results = null;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            REGISTRANT_JSON record = manager.GetJsonData(id, AHOBPRGlobal.AhobprJsonDataTypeInfo);
            if (record != null)
            {
                results = record.JSON_DATA;
            }

            return results;
        }

        /// <summary>
        /// Get all the user follow-up forms
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string BprUserFollowupForms(string id)
        {
            string results = null;
            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            List<string> records = manager.GetJsonFollowups(id, AHOBPRGlobal.AhobprJsonTypeUserForm);
            if (records.Count > 0)
            {
                JavaScriptSerializer serializer = new JavaScriptSerializer();
                BprUserFollowupForm userForm = new BprUserFollowupForm();
                List<BprUserFollowupForm> userFormList = new List<BprUserFollowupForm>();
                foreach (string userFormJson in records)
                {
                    userForm = serializer.Deserialize<BprUserFollowupForm>(userFormJson);
                    userFormList.Add(userForm);
                }
                BprUserFollowupForms userForms = new BprUserFollowupForms();
                userForms._id = Guid.NewGuid().ToString();
                userForms.userFollowupForms = userFormList.ToArray();
                results = serializer.Serialize(userForms);
            }
            return results;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string BprMessages(string id)
        {
            string results = null;
            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            List<string> records = manager.GetJsonFollowups(id, AHOBPRGlobal.AhobprJsonTypeMessage);
            if (records.Count > 0)
            {
                JavaScriptSerializer serializer = new JavaScriptSerializer();
                BprMessage message = new BprMessage();
                List<BprMessage> messages = new List<BprMessage>();
                foreach (string jsonData in records)
                {
                    message = serializer.Deserialize<BprMessage>(jsonData);
                    message.body = message.body.Replace("\r\n", "<br />");
                    messages.Add(message);
                }
                BprMessages bprMessages = new BprMessages();
                bprMessages.userId = id;
                messages = (from m in messages
                            orderby Convert.ToInt32(m._id) descending
                            select m).ToList();
                bprMessages.messages = messages.ToArray();
                results = serializer.Serialize(bprMessages);
            }
            return results;

        }

        /// <summary>
        /// Get BprUser
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string BprUser(string id)
        {
            string results = string.Empty;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            REGISTRANT_JSON record = manager.GetJsonData(id, AHOBPRGlobal.AhobprJsonDataTypeUser);
            if (record != null)
            {
                results = record.JSON_DATA;
            }

            return results;

        }

        /// <summary>
        /// Get BprUserId
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string BprUserId(string id)
        {
            string userId = string.Empty;

            if (!string.IsNullOrEmpty(id))
            {
                AHOBPRRegistrantManager manager = new AHOBPRRegistrantManager();
                userId = manager.GetUserIdByRegistrantId(Convert.ToInt32(id));
            }

            return userId;
        }

        /// <summary>
        /// Get the metadata for PDF
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        public string PdfMetaData(string userid)
        {
            string result = string.Empty;

            AHOBPRFileManager manager = new AHOBPRFileManager();
            result = manager.GetPdfMetaData(userid);

            return result;
        }

        /// <summary>
        /// Get the last PDF run date
        /// </summary>
        /// <returns></returns>
        public string LastPdfRunDate()
        {
            string result = string.Empty;

            AHOBPRFileManager manager = new AHOBPRFileManager();
            result = manager.GetLastPdfRunDate();

            return result;
        }

        /// <summary>
        /// Get PDF registrant list by questionnaire completed date range
        /// </summary>
        /// <param name="startdate"></param>
        /// <param name="enddate"></param>
        /// <returns></returns>
        public List<string> PdfRegistrantList(string startdate, string enddate)
        {
            List<string> urserIds = null;

            if (!string.IsNullOrEmpty(startdate) && !string.IsNullOrEmpty(enddate))
            {
                AHOBPRFileManager manager = new AHOBPRFileManager();
                urserIds = manager.PdfRegistrantList(startdate, enddate);
            }

            return urserIds;
        }

        /// <summary>
        /// Get Bpr Responses
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string BprResponses(string id)
        {
            string results = null;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            REGISTRANT_JSON record = manager.GetJsonData(id, AHOBPRGlobal.AhobprJsonDataTypeResponses);
            if (record != null)
            {
                results = record.JSON_DATA;
            }

            return results;

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool ReopenQuestionnaire(string id)
        {
            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            return manager.reopenQuestionnaire(id);
        }

        /// <summary>
        /// Get Bpr Form
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string BprForm(string id)
        {
            string results = null;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            REGISTRANT_JSON record = manager.GetJsonData(id, AHOBPRGlobal.AhobprJsonDataTypeForm);
            if (record != null)
            {
                results = record.JSON_DATA;
            }

            return results;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string BprFormFollowup(string id)
        {
            string results = null;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            results = manager.GetJsonFollowup(id, AHOBPRGlobal.AhobprJsonTypeFormFollowup, id);

            return results;
        }

        public string DefaultBprFormId()
        {
            return AHOBPRGlobal.AhobprDefaultFormId;
        }

        /// <summary>
        /// Get Deployment Locations
        /// </summary>
        /// <returns></returns>
        public string BprDeploymentLocations(string search)
        {
            string results = string.Empty;
            JavaScriptSerializer serializer = new JavaScriptSerializer();
            AHOBPRDODDeploymentManager manager = new AHOBPRDODDeploymentManager();
            BprDeploymentLocation[] locations = manager.GetDeploymentLocations(search.Replace("__", " ").Replace("__", " ").Replace("__", " ").Replace("__", " ").Replace("__", " "));
            results = serializer.Serialize(locations);
            return results;
        }

        /// <summary>
        /// Search deployment locations and return deployment base names
        /// </summary>
        /// <param name="search"></param>
        /// <returns></returns>
        public string BprBaseNames(string search)
        {
            string results = string.Empty;
            AHOBPRDODDeploymentManager manager = new AHOBPRDODDeploymentManager();
            JavaScriptSerializer serializer = new JavaScriptSerializer();

            BprDeploymentBaseName[] bases = manager.GetDeploymentBaseNames(search.Replace("__", " ").Replace("__", " ").Replace("__", " ").Replace("__", " ").Replace("__", " "));
            results = serializer.Serialize(bases);

            return results;
        }

        /// <summary>
        /// Update registrant's name
        /// </summary>
        /// <param name="userid"></param>
        /// <param name="lastname"></param>
        /// <param name="firstname"></param>
        /// <param name="createdby"></param>
        /// <returns></returns>
        public bool NameUpdate2(string userid, string lastname, string firstname, string createdby)
        {
            return this.NameUpdate(userid, lastname, firstname, string.Empty, createdby);
        }

        /// <summary>
        /// Update registrant's name
        /// </summary>
        /// <param name="userid"></param>
        /// <param name="lastname"></param>
        /// <param name="firstname"></param>
        /// <param name="middlename"></param>
        /// <param name="createdby"></param>
        /// <returns></returns>
        public bool NameUpdate(string userid, string lastname, string firstname, string middlename, string createdby)
        {
            bool results = false;
            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            JavaScriptSerializer serializer = new JavaScriptSerializer();
            REGISTRANT_JSON record = null;

            // Update User Json with new name
            record = manager.GetJsonData(userid, AHOBPRGlobal.AhobprJsonDataTypeUser);
            if (record != null)
            {
                BprUser bprUser = serializer.Deserialize<BprUser>(record.JSON_DATA);
                bprUser.firstName = firstname;
                bprUser.lastName = lastname;
                bprUser.middleName = middlename;

                results = SaveBprUser(userid, serializer.Serialize(bprUser), createdby) != null;
            }


            // Update Info Json with new name
            record = manager.GetJsonData(userid, AHOBPRGlobal.AhobprJsonDataTypeInfo);
            if (record != null)
            {
                BprInfo bprInfo = serializer.Deserialize<BprInfo>(record.JSON_DATA);
                if (bprInfo != null)
                {
                    bprInfo.edipiMismatched = false;
                    bprInfo.edipiVerifiedDate = string.Empty;
                    if (bprInfo.contactInfo != null)
                    {
                        bprInfo.contactInfo.firstName = firstname;
                        bprInfo.contactInfo.lastName = lastname;
                        bprInfo.contactInfo.middleName = middlename;
                    }
                    results = SaveBprInfo(userid, serializer.Serialize(bprInfo), createdby) != null;
                }
            }

            return results;
        }

        public string TotalParticipants()
        {
            AHOBPRRegistrantManager manager = new AHOBPRRegistrantManager();
            return manager.GetTotalParticipants();
        }

        /// <summary>
        /// Update registrant status
        /// </summary>
        /// <param name="userid"></param>
        /// <param name="newstatus"></param>
        /// <returns></returns>
        public String UpdateRegistrantStatus(String userid, String newstatus, String createdby)
        {
            string results = string.Empty;
            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            JavaScriptSerializer serializer = new JavaScriptSerializer();

            // Update User Json with new status
            REGISTRANT_JSON record = manager.GetJsonData(userid, AHOBPRGlobal.AhobprJsonDataTypeUser);
            if (record != null)
            {
                BprUser bprUser = serializer.Deserialize<BprUser>(record.JSON_DATA);

                bprUser.userState = new BprUserState() { lastUpdated = DateTime.UtcNow.ToString("yyyy-MM-ddTHH:mm:ss.fffZ"), state = newstatus };
                results = SaveBprUser(userid, serializer.Serialize(bprUser), createdby);
            }

            //Moved logic to SaveBprUser

            return results;
        }

        /// <summary>
        /// Create a new followup form json when a tool form is submitted
        /// </summary>
        /// <param name="toolformid"></param>
        /// <returns></returns>
        public bool CreateFollowUpFormJson(string toolformid, string issystemwide, string createdby)
        {
            bool result = false;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            result = manager.CreateFollowupFormJson(toolformid, issystemwide, createdby);

            return result;
        }

        /// <summary>
        /// Update system wide flag for the follow-up form json
        /// </summary>
        /// <param name="toolformid"></param>
        /// <param name="issystemwide"></param>
        /// <returns></returns>
        public bool UpdateFollowupFormJsonSystemWide(string toolformid)
        {
            bool result = false;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            result = manager.UpdateFollowupFormJsonSystemWide(toolformid);

            return result;
        }

        /// <summary>
        /// Get a list of system wide follow-up form json
        /// </summary>
        /// <returns></returns>
        public string SystemWideFormJsons()
        {
            string results = string.Empty;
            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            List<string> records = manager.GetSystemWideFormJsons();
            if (records.Count > 0)
            {
                JavaScriptSerializer serializer = new JavaScriptSerializer();
                BprUserFollowupForm userForm = new BprUserFollowupForm();
                BprForm form = new BprForm();
                List<BprUserFollowupForm> userFormList = new List<BprUserFollowupForm>();
                foreach (string formJson in records)
                {
                    form = serializer.Deserialize<BprForm>(formJson);
                    userForm = new BprUserFollowupForm();
                    userForm._id = form._id;
                    userForm.name = form.name;
                    userForm.title = form.title;
                    userFormList.Add(userForm);
                }
                BprUserFollowupForms userForms = new BprUserFollowupForms();
                userForms._id = Guid.NewGuid().ToString();
                userForms.userFollowupForms = userFormList.ToArray();
                results = serializer.Serialize(userForms);
            }

            return results;
        }

        /// <summary>
        /// Get the responses for follow-up questionnaire
        /// </summary>
        /// <param name="userid"></param>
        /// <param name="formid"></param>
        /// <returns></returns>
        public string BprFollowUpFormResponse(string userid, string formid)
        {
            string result = string.Empty;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            result = manager.GetJsonFollowup(userid, AHOBPRGlobal.AhobprJsonTypeResponsesFollowup, formid);

            return result;
        }

        /// <summary>
        /// Create json for message
        /// </summary>
        /// <param name="registrantId"></param>
        /// <param name="emailtemplateid"></param>
        /// <returns></returns>
        public bool CreateMessageJson(string registrantId, string emailtemplateid, string createdby)
        {
            bool result = false;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            result = manager.CreateMessageJson(registrantId, emailtemplateid, createdby);

            return result;
        }

        public bool CreateUserFormJson(string registrantid, string formid, string createdby)
        {
            bool result = false;
            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            result = manager.CreateUserFormJson(registrantid, formid, createdby);

            return result;
        }

        public String UpdateDefaultFormId(String defaultformid)
        {
            String results = String.Empty;

            try
            {
                System.Configuration.Configuration config =
                    System.Web.Configuration.WebConfigurationManager.OpenWebConfiguration("~");
                System.Configuration.KeyValueConfigurationElement setting = config.AppSettings.Settings["MyValue"];
                config.AppSettings.Settings["AhobprDefaultFormId"].Value = defaultformid;
                config.Save();
                results = "true";
            }
            catch //(Exception ex)
            {
                results = "false";
            }

            return results;
        }

        public bool ResetDatabase()
        {
            AHOBPRGenericManager manager = new AHOBPRGenericManager();
            return manager.ResetDatabase();
        }

        /// <summary>
        /// Delete a registrant by registrant ID
        /// </summary>
        /// <param name="registrantid"></param>
        /// <returns></returns>
        public bool DeteleRegistrant(string registrantid)
        {
            if (string.IsNullOrEmpty(registrantid) || registrantid.All(Char.IsDigit) == false)
            {
                return true;
            }
            else
            {
                AHOBPRGenericManager manager = new AHOBPRGenericManager();
                int id = Convert.ToInt32(registrantid);
                return manager.DeteleRegistrant(id);
            }

        }

        /// <summary>
        /// Delete CPRS log entries for a registrant by registrant ID
        /// </summary>
        /// <param name="registrantid"></param>
        /// <returns></returns>
        public bool DeteleCprsLog(string registrantid)
        {
            if (string.IsNullOrEmpty(registrantid) || registrantid.All(Char.IsDigit) == false)
            {
                return true;
            }
            else
            {
                AHOBPRGenericManager manager = new AHOBPRGenericManager();
                int id = Convert.ToInt32(registrantid);
                return manager.DeteleCprsLog(id);
            }

        }

        public bool SetMigrationMode(String newMode)
        {
            if (newMode.ToLower() == "migration")
            {
                SetServiceMode("migration");
            }
            else
            {
                //Clear the process metrics table:
                (new AHOBPRGenericManager()).ClearProcessMetrics();

                SetServiceMode("normal");
            }
            return true;
        }

        private void SetServiceMode(String newServiceMode)
        {

            System.Configuration.Configuration config =
                System.Web.Configuration.WebConfigurationManager.OpenWebConfiguration("~");
            System.Configuration.KeyValueConfigurationElement setting = config.AppSettings.Settings["MyValue"];
            config.AppSettings.Settings["ServiceMode"].Value = newServiceMode;
            config.Save();
        }

        public byte[] GetDasPdf(String registrantid)
        {
            byte[] value = new byte[0];

            try
            {
                value = AHOBPRShared.GetDasPdf(registrantid);
            }
            catch (Exception) { }

            return value;
        }

        #endregion

        private static IDeploymentImporter CreateDoDImporter()
        {
            IDeploymentImporter manager = null;
            string importerClassName = WebConfigurationManager.AppSettings["DeploymentImporterClass"].ToString();
            var assembly = Assembly.GetAssembly(typeof(AHOBPRBaseBO));
            Type type = assembly.GetType(importerClassName);
            if (type == null)
                throw new NullReferenceException($"{importerClassName} not found in assembly '{assembly.FullName}'. Is the class name in the Web.Config setting 'DeploymentImporterClass' configured correctly?");
            try
            {
                manager = Activator.CreateInstance(type) as IDeploymentImporter;
            }
            catch (Exception ex)
            {

                AHOBPRLogger.LogErrorMessage("Exception: " + ex.Message, "AHOBPR.svc." + MethodBase.GetCurrentMethod().Name, ex.StackTrace);
            }
            return manager;
        }

        #region Scripts

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public string ScriptsBatch()
        {
            AHOBPRScriptsManager manager = new AHOBPRScriptsManager();
            string results = manager.GetScriptsBatch();
            return results;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="id"></param>
        /// <param name="type"></param>
        /// <returns></returns>
        public bool UpdateScriptsBatchStatus(string id, string type)
        {
            bool result = false;
            AHOBPRScriptsManager manager = new AHOBPRScriptsManager();
            result = manager.UpdateScriptsBatchStatus(id, type);
            return result;
        }

        #endregion

        #region POST Methods for Registrant Portal

        /// <summary>
        /// Save File
        /// </summary>
        /// <param name="fileType"></param>
        /// <param name="fileId"></param>
        /// <param name="pdfStream"></param>
        /// <returns></returns>
        public bool SaveFile(string fileType, string fileId, Stream fileStream)
        {
            bool result = false;

            AHOBPRFileManager manager = new AHOBPRFileManager();
            result = manager.SaveFile(fileId, fileType, fileStream);

            return result;
        }

        /// <summary>
        /// Save Bpr Info
        /// </summary>
        /// <param name="bprInfo"></param>
        /// <returns></returns>
        public string SaveBprInfo(string userId, string bprInfo)
        {
            return this.SaveBprInfo(userId, bprInfo, string.Empty);
        }

        /// <summary>
        /// Save Bpr Info
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="bprInfo"></param>
        /// <param name="createdBy"></param>
        /// <returns></returns>
        private string SaveBprInfo(string userId, string bprInfo, string createdBy)
        {
            string results = string.Empty;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            REGISTRANT_JSON registrantJson = manager.SaveJsonData(userId, AHOBPRGlobal.AhobprJsonDataTypeInfo, bprInfo, createdBy);
            if (registrantJson != null)
            {
                try
                {
                    results = registrantJson.JSON_DATA;
                }
                catch
                {
                    results = string.Empty;
                }
            }

            return results;
        }

        /// <summary>
        /// Save Bpr User
        /// </summary>
        /// <param name="bprUser"></param>
        /// <returns></returns>
        public string SaveBprUser(string userId, string bprUser)
        {
            return this.SaveBprUser(userId, bprUser, string.Empty);
        }

        /// <summary>
        /// Save Bpr User
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="bprUser"></param>
        /// <param name="createdBy"></param>
        /// <returns></returns>
        private string SaveBprUser(string userId, string bprUser, string createdBy)
        {
            string results = string.Empty;
            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            JavaScriptSerializer serializer = new JavaScriptSerializer();
            REGISTRANT_JSON record = null;
            string oldStatus = string.Empty;
            string newStatus = string.Empty;

            // Get latest user record
            record = manager.GetJsonData(userId, AHOBPRGlobal.AhobprJsonDataTypeUser);
            if (record != null)
            {
                BprUser oldUser = serializer.Deserialize<BprUser>(record.JSON_DATA);
                if (oldUser != null) oldStatus = oldUser.userState.state;

                BprUser newUser = serializer.Deserialize<BprUser>(bprUser);
                if (newUser != null) newStatus = newUser.userState.state;

                //There is a defect where old MongoDB session data is overwriting SQL Server data
                //Do not allow status updates if it regresses the user back to a lower status
                if ((oldStatus == "PARTICIPANT" || oldStatus == "ELIGIBLE" || oldStatus == "REVIEWED_ELIGIBLE" || oldStatus == "REVIEWED_NOT_ELIGIBLE")
                    && (newStatus == "NOT_ELIGIBLE" || newStatus == "REVIEW" || newStatus == "CONSENT" || newStatus == "NOT_CONSENT" || newStatus == "REVIEW_REQUESTED"))
                {
                    newStatus = oldStatus;
                }
                else if ((oldStatus == "ELIGIBLE")
                    && (newStatus == "REVIEWED_NOT_ELIGIBLE" || newStatus == "REVIEWED_ELIGIBLE"))
                {
                    newStatus = oldStatus;
                }

                newUser.userState = new BprUserState() { lastUpdated = DateTime.UtcNow.ToString("yyyy-MM-ddTHH:mm:ss.fffZ"), state = newStatus };

                bprUser = serializer.Serialize(newUser);
            }

            REGISTRANT_JSON registrantJson = manager.SaveJsonData(userId, AHOBPRGlobal.AhobprJsonDataTypeUser, bprUser, createdBy);
            if (registrantJson != null)
            {
                results = registrantJson.JSON_DATA;

                try
                {
                    //Update Registrant Table
                    manager.ParseUserJson(results);
                }
                catch
                {
                    results = string.Empty;
                }
            }

            ////Per Mitch 06/07/2017 - Deployments should not be deleted
            ////Delete deployments for the registrants with status - REVIEWED_NOT_ELIGIBLE
            //if (newStatus == "REVIEWED_NOT_ELIGIBLE" && oldStatus != "PARTICIPANT")
            //{
            //    // delete deployments from info json
            //    record = manager.GetJsonData(userId, AHOBPRGlobal.AhobprJsonDataTypeInfo);
            //    if (record != null)
            //    {
            //        BprInfo bprInfo = serializer.Deserialize<BprInfo>(record.JSON_DATA);
            //        if (bprInfo != null)
            //        {
            //            if (bprInfo.deploymentHistory.Length > 0)
            //            {
            //                //Array.Clear(bprInfo.deploymentHistory, 0, bprInfo.deploymentHistory.Length);

            //                //Reinitialize  array to clear deployment history
            //                bprInfo.deploymentHistory = (new List<BprDeploymentHistory>()).ToArray();
            //            }

            //            if (bprInfo.deploymentReconsider.history.Length > 0)
            //            {
            //                //Array.Clear(bprInfo.deploymentReconsider.history, 0, bprInfo.deploymentReconsider.history.Length);

            //                //Reinitialize  array to clear deployment history
            //                bprInfo.deploymentReconsider.history = (new List<BprDeploymentHistory>()).ToArray();

            //            }
            //            SaveBprInfo(userId, serializer.Serialize(bprInfo), createdBy);
            //        }
            //    }
            //}

            //Business Rule: Registrant can correct errors within 30 days
            //Below will clear out completed dates and pdf files
            if (oldStatus == "PARTICIPANT" && newStatus != "PARTICIPANT")
            {
                // Update the response json if it has questionnaire completed date
                record = manager.GetJsonData(userId, AHOBPRGlobal.AhobprJsonDataTypeResponses);
                if (record != null && !string.IsNullOrEmpty(record.JSON_DATA))
                {
                    //There is response JSON data in the database with an array type for "answerValue"
                    //however the plural "answerValues" is supposed to be used for an array answer
                    string search = "answerValue" + '"' + ":[";
                    string replace = "answerValues" + '"' + ":[";
                    record.JSON_DATA = record.JSON_DATA.Replace(search, replace);

                    BprResponses bprResponses = serializer.Deserialize<BprResponses>(record.JSON_DATA);
                    if (bprResponses != null)
                    {
                        if (bprResponses.responseStatus != null)
                        {
                            if (!string.IsNullOrEmpty(bprResponses.responseStatus.questionnaireCompletedDate))
                            {
                                bprResponses.responseStatus.questionnaireCompletedDate = string.Empty;
                                SaveBprResponses(userId, serializer.Serialize(bprResponses));

                                //Remove the PDF file
                                AHOBPRFileManager fileManager = new AHOBPRFileManager();
                                fileManager.DeleteFile(userId, AHOBPRGlobal.AhobprFileTypeResponsePdf);

                                //Remove the QuestionnaireCompletedDate from FORM_RESPONSE_STATUS table
                                AHOBPRFormResponseManager responseMananger = new AHOBPRFormResponseManager();
                                responseMananger.RemoveQuestionnaireCompleteDate(userId);
                            }
                        }
                    }
                }
            }

            return results;
        }

        /// <summary>
        /// Save Bpr Responses
        /// </summary>
        /// <param name="bprResponses"></param>
        /// <returns></returns>
        public string SaveBprResponses(string userId, string bprResponses)
        {
            string results = string.Empty;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            REGISTRANT_JSON registrantJson = manager.SaveJsonData(userId, AHOBPRGlobal.AhobprJsonDataTypeResponses, bprResponses, string.Empty);
            if (registrantJson != null)
            {
                try
                {
                    results = registrantJson.JSON_DATA;
                }
                catch
                {
                    results = string.Empty;
                }
            }
            return results;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="formId"></param>
        /// <param name="bprResponses"></param>
        /// <returns></returns>
        public string SaveBprFollowupResponses(string userId, string formId, string bprResponses)
        {
            string results = string.Empty;
            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            REGISTRANT_JSON_FOLLOWUP registrantJson = manager.SaveJsonFollowupData(userId, AHOBPRGlobal.AhobprJsonTypeResponsesFollowup, formId, bprResponses, AHOBPRGlobal.AhobprJsonStatusCompleted, "no", string.Empty);
            if (registrantJson != null)
            {
                try
                {
                    UpdateUserFollowupFormStatus(userId, formId);
                    results = registrantJson.JSON_DATA;
                }
                catch
                {
                    results = string.Empty;
                }
            }

            return results;
        }

        /// <summary>
        /// Update messages status from new to completed
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="bprMessages"></param>
        /// <returns></returns>
        public string UpdateMessageStatus(string userId, string bprMessages)
        {
            string results = string.Empty;
            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            List<string> records = manager.GetJsonFollowups(userId, AHOBPRGlobal.AhobprJsonTypeMessage);
            if (records.Count > 0)
            {
                JavaScriptSerializer serializer = new JavaScriptSerializer();
                BprMessage message = new BprMessage();
                List<BprMessage> messages = new List<BprMessage>();
                foreach (string jsonData in records)
                {
                    message = serializer.Deserialize<BprMessage>(jsonData);
                    if (message.status == AHOBPRGlobal.AhobprJsonStatusNew)
                    {
                        message.status = AHOBPRGlobal.AhobprJsonStatusCompleted;
                        message.completedDate = DateTime.Now.ToString();
                        string messageJson = serializer.Serialize(message);
                        manager.SaveJsonFollowupData(userId, AHOBPRGlobal.AhobprJsonTypeMessage, message._id, messageJson, AHOBPRGlobal.AhobprJsonStatusCompleted, "no", string.Empty);
                    }
                    messages.Add(message);
                }
                BprMessages newMessages = new BprMessages();
                newMessages.userId = userId;
                messages = (from m in messages
                            orderby m._id descending
                            select m).ToList();
                newMessages.messages = messages.ToArray();
                results = serializer.Serialize(newMessages);
            }

            return results;
        }

        /// <summary>
        /// After a registrant completes a follow-up questionnaire, the status will be changed to "Completed"
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="formId"></param>
        private void UpdateUserFollowupFormStatus(string userId, string formId)
        {
            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            JavaScriptSerializer serializer = new JavaScriptSerializer();
            string userFormJson = manager.GetJsonFollowup(userId, AHOBPRGlobal.AhobprJsonTypeUserForm, formId);
            if (!string.IsNullOrEmpty(userFormJson))
            {
                BprUserFollowupForm userForm = serializer.Deserialize<BprUserFollowupForm>(userFormJson);
                if (userForm != null)
                {
                    userForm.status = AHOBPRGlobal.AhobprJsonStatusCompleted;
                    userForm.completedDate = DateTime.Now.ToString();
                    userFormJson = serializer.Serialize(userForm);
                    manager.SaveJsonFollowupData(userId, AHOBPRGlobal.AhobprJsonTypeUserForm, formId, userFormJson, AHOBPRGlobal.AhobprJsonStatusCompleted, "no", string.Empty);
                }
            }
            else // create new user_form with completed status for system wide follow-up forms
            {
                AHOBPRFormResponseManager formManager = new AHOBPRFormResponseManager();
                STD_FORM form = formManager.GetFormByBprId(formId);
                BprUserFollowupForm userForm = new BprUserFollowupForm();
                userForm._id = form.BPR_FORM_ID;
                userForm.name = form.NAME;
                userForm.title = form.TITLE;
                userForm.sentDate = DateTime.Now.ToString();
                userForm.status = AHOBPRGlobal.AhobprJsonStatusCompleted;
                userForm.completedDate = DateTime.Now.ToString();
                userFormJson = serializer.Serialize(userForm);
                manager.SaveJsonFollowupData(userId, AHOBPRGlobal.AhobprJsonTypeUserForm, formId, userFormJson, AHOBPRGlobal.AhobprJsonStatusCompleted, "yes", string.Empty);
            }
        }

        //private void WriteToLog(string message)
        //{
        //    StreamWriter logFile = new StreamWriter(@"c:\debug.log");
        //    logFile.WriteLine(message);
        //    logFile.Close();
        //}

        /// <summary>
        /// Save Bpr Form
        /// </summary>
        /// <param name="formId"></param>
        /// <param name="bprForm"></param>
        /// <returns></returns>
        public bool SaveBprForm(string formId, string bprForm)
        {
            bool results = false;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            REGISTRANT_JSON registrantJson = manager.SaveJsonData(formId, AHOBPRGlobal.AhobprJsonDataTypeForm, bprForm, string.Empty);
            if (registrantJson != null)
            {
                try
                {
                    results = registrantJson.JSON_DATA.Length > 0;
                }
                catch
                {
                    results = false;
                }
            }
            return results;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        public bool UpdateVistaLogin(String userid)
        {
            return (new AHOBPRUserManager()).UpdateLastVistaLogin(userid);
        }

        /// <summary>
        /// Process the general queue
        /// </summary>
        /// <returns></returns>
        public bool ProcessQueueBatch(string queuebatchid)
        {
            return (new AHOBPRQueueManager()).ProcessQueueBatch(queuebatchid);
        }

        /// <summary>
        /// Save data access log
        /// </summary>
        /// <param name="dataAccessLog"></param>
        /// <returns></returns>
        public bool SaveDataAccessLog(DataAccessLog dataAccessLog)
        {
            AHOBPRGenericManager manager = new AHOBPRGenericManager();
            return manager.SaveDataAccessLog(dataAccessLog.userId, dataAccessLog.pageName, dataAccessLog.userAgent);
        }

        /// <summary>
        /// Save interface log
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        public bool SaveInterfaceLog(string userId, string value)
        {
            AHOBPRGenericManager manager = new AHOBPRGenericManager();
            return manager.SaveInterfaceLog(userId, value);
        }

        #endregion
    }
}
